function [c1est,c2est,phi1est,phi2est,stderror1,stderror2,sig1est,sig2est,n1,n2] = estimasetar(x,p1,p2,d,r)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% MATLAB code: example 6.7 
% File: estimasetar.m
%
% This function estimates a two-regime threshold AR model given (p1,p2,d,r).
%
% INPUT:
% x  = the series
% p1 = AR order of the first regime
% p2 = AR order of the second regime
% d  = delay
% r  = threshold
%
% OUTPUT:
% c1est     = estimated constant of the first regime
% c2est     = estimated constant of the second regime
% phi1est   = vector of estimated parameters of the first regime
% phi2est   = vector of estimated parameters of the second regime
% stderror1 = standard error of the parameter estimates of the first regime
% stderror2 = standard error of the parameter estimates of the second regime
% sig1est   = residual variance of the first regime
% sig2est   = residual variance of the second regime
% n1        = number of data in the first regime
% n2        = the number of data in the second regime
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[si1,si2] = size(x);
if si1 > 1
   x = x';
end

n  = length(x);
h  = max([p1 p2 d]) + 1;
Y1 = [];
X1 = [];
Y2 = [];
X2 = [];

for i = h : n
    if x(i - d) <= r
       Y1 = [Y1;x(i)];
       X1 = [X1;[1 x((i-1):-1:(i-p1))]];
    else
       Y2 = [Y2;x(i)];
       X2 = [X2;[1 x((i-1):-1:(i-p2))]];
    end
end

n1      = length(Y1);
n2      = length(Y2);
aux1    = inv(X1'*X1)*X1'*Y1;
c1est   = aux1(1);
phi1est = aux1(2:(p1+1));
aux2    = inv(X2'*X2)*X2'*Y2;
c2est   = aux2(1);
phi2est = aux2(2:(p2+1));
sig1est = var(Y1-X1*aux1,1);
sig2est = var(Y2-X2*aux2,1);

stderror1 = sqrt(diag(sig1est * inv(X1'*X1)));
stderror2 = sqrt(diag(sig2est * inv(X2'*X2)));
